/*
 * LikelihoodEstimators.h
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */

#ifndef LIKELIHOODESTIMATORS_H_
#define LIKELIHOODESTIMATORS_H_



#include <StandardLibs.h>
#include <Similarity.h>
#include <NetworkStructure.h>
#include <ContagionStatistics.h>
#include <ContagionParameters.h>
#include <ContagionModels.h>
#include <BeliefPropagation.h>
#include <IgraphVersionCompile.h>

#define LIKELIHOOD_METHOD_AUCDF 1
#define LIKELIHOOD_METHOD_AVGTOPK 2
#define LIKELIHOOD_METHOD_NAIVE 3
#define LIKELIHOOD_METHOD_DMP 4
#define LIKELIHOOD_NAIVE_BOUNDARY 5
#define LIKELIHOOD_METHOD_AVGTOPK_JORDAN_PRIOR 6
#define LIKELIHOOD_METHOD_AVGTOPK_DISTANCE_PRIOR 7
#define LIKELIHOOD_METHOD_JORDAN 8
#define LIKELIHOOD_METHOD_DISTANCE 9
#define LIKELIHOOD_METHOD_UNBIASED 10 //brute force
#define LIKELIHOOD_METHOD_SOFT_MARGIN 11
#define LIKELIHOOD_METHOD_UNBIASED_PRUNNING 12
#define LIKELIHOOD_METHOD_SOFT_MARGIN_PRUNING 13
#define LIKELIHOOD_METHOD_RAND_UNIFORM 14
#define LIKELIHOOD_METHOD_CONST_ALL 15
#define LIKELIHOOD_METHOD_SOFT_MARGIN_A_RANGE 16
#define PI 3.141592653589793238462643
#define SQRTPI (double) 1.7724538509055160273

typedef struct {
	int phi_type;
	int likelihood_method;
	pair<double, double> likelihood_param;

	//additional parameters for soft margin
	vector<double> a_array;
	vector<double> likelihood_theta_a_array;

} likelihood_struct;



double calculate_realization_likelihood( statistics * statistic_parameters, infected_structure * p_infected_parameters, contagion_param_struct * epidemicParameters_exp, likelihood_struct * likelihood_fun);

double calculate_realization_likelihood_avgTopK(infected_structure * p_infected_parameters, statistics * statistic_parameters, contagion_param_struct * epidemicParameters_exp, likelihood_struct * likelihood_fun);

void find_node_activity_times(infected_structure * p_infected_parameters, vector<int> * node_activity_times, contagion_param_struct * epidemicParameters_exp);

double average_top_k_scores( igraph_vector_t * scores_array, int k );

double calculate_realization_likelihood_unbiased_prunning(double p, double q, infected_structure * p_infected_parameters, statistics * statistic_parameters, igraph_vector_t * observed_realization, int  T_value);

double calculate_realization_likelihood_naive( statistics * statistic_parameters, infected_structure * p_infected_parameters, contagion_param_struct * epidemicParameters_exp, likelihood_struct * likelihood_fun);

double calculate_realization_likelihood_SOFT_MARGIN(statistics * statistic_parameters, infected_structure * p_infected_parameters, contagion_param_struct * epidemicParameters_exp, likelihood_struct * likelihood_fun);

double calculate_realization_likelihood_SOFT_MARGIN_a_range(statistics * statistic_parameters, infected_structure * p_infected_parameters, contagion_param_struct * epidemicParameters_exp, likelihood_struct * likelihood_fun);

double weighted_soft_margin( igraph_vector_t * scores_array, double sigma );

double general_dirac( double x, double sigma);

double general_dirac_norm( double sigma );

double source_prob_distr_ML_rel_error(double * likeihood_new, double * likelihood_old, int size);

double calculate_realization_likelihood_AUCDF(statistics * statistic_parameters, infected_structure * p_infected_parameters, contagion_param_struct * epidemicParameters_exp, likelihood_struct * likelihood_fun);

double areaUnderCDF(igraph_vector_t * scores_array);

double calculate_realization_likelihood_JORDAN(infected_structure * p_infected_parameters, igraph_vector_t * infected_nodes);

void find_infected_subgraph(infected_structure * p_infected_parameters, igraph_vector_t * infected_nodes, igraph_t * inf_subgraph);

double calculate_realization_likelihood_DISTANCE(infected_structure * p_infected_parameters, igraph_vector_t * infected_nodes);

double calculate_realization_likelihood_DMP(double p, double q, infected_structure * p_infected_parameters, igraph_vector_t * observed_realization, int T_value);

double calculate_realization_likelihood_SOFT_MARGIN_MC_PRUNING(statistics * statistic_parameters, infected_structure * p_infected_parameters, contagion_param_struct * epidemicParameters_exp, likelihood_struct * likelihood_fun);

void copy_likelihood_vector(double * source, double * dest, int size);

int source_prob_distr_converged(double * likeihood_new, double * likelihood_old, int size, double convergence_threshold);

int source_prob_distr_ML_converged(double * likeihood_new, double * likelihood_old, int size, double convergence_threshold);

int rank_ML_converged(double * likeihood_new, double * likelihood_old, int size);

int recalc_likelihoods_old_new(double * likelihood_new, double * likelihood_old, int size, int num_sim_new, int num_sim_old);

void generate_realizations_for_export(statistics * statistic_parameters, infected_structure * p_infected_parameters, contagion_param_struct * epidemicParameters_exp);

void find_infected_subgraph_temporal(infected_structure * p_infected_parameters, igraph_vector_t * infected_nodes, igraph_t * inf_subgraph);

double calculate_realization_likelihood_unbiased(double p, double q, infected_structure * p_infected_parameters, statistics * statistic_parameters, igraph_vector_t * observed_realization, int  T_value);
#endif /* LIKELIHOODESTIMATORS_H_ */
